<?php

namespace App\Models;

use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use App\Notifications\ResetPassword as ResetPasswordNotification;

use App\Notifications\ResetPassword;

class Account extends Authenticatable
{
    const ACTIVE = 1;
    const INACTIVE = 0;

    use Notifiable;
 
    protected $guard = 'account';

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'accounts';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'first_name', 'last_name', 'email', 'contact_number', 'company_name', 'address_line_one', 'address_line_two', 'town', 'county', 'country', 'postcode', 'active', 'password', 'remember_token'
    ];

    /**
     * Returns an array of all accounts
     * @return array
     */
    public static function getAll()
    {
        return Account::orderBy('created_at', 'asc')->get();
    }

    /**
     * Check if account is active using the email
     * @return array
     */
    public static function isActiveAccount($email)
    {
        $status = self::where('email', $email)->first()['active'];
        if($status == self::ACTIVE) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Send the password reset notification.
     *
     * @param  string  $token
     * @return void
     */
    public function sendPasswordResetNotification($token)
    {
        $this->notify(new ResetPassword($token));
    }
}
