@extends('admin.view')

@section('content')

    <div class="container-fluid">
        <h2>Update Setting</h2>
        <form action="/admin/settings/store" method="post" enctype="multipart/form-data">
            @csrf
            <input type="hidden" name="id" value="{{ $item->id }}">

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <h3>Description for {!! $item->setting !!} Setting</h3>
                        <p>{!! $item->description !!}</p>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>{!! $item->setting !!}</label>
                                    @if($item->type=="text")
                                        <input type="text" name="value" class="form-control" value="{!! $item->value !!}" required>
                                    @elseif($item->type=="textarea")
                                        <textarea name="value" class="form-control" required>{!! $item->value !!}</textarea>
                                    @elseif($item->type=="html")
                                        <textarea name="value" class="tiny" required>{!! $item->value !!}</textarea>
                                    @else
                                        <input type="text" name="value" class="form-control" value="{!! $item->value !!}" required>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <button type="submit" class="btn btn-success">Update Setting</button>
                    <a href="{{ route('admin.settings.index') }}" class="btn btn-default">Cancel</a>
                </div>
            </div>

        </form>
    </div>

@endsection
