@extends('admin.view')

@section('content')

    <div class="container-fluid">
        <div class="row">
            <div class="col-md-6">
                <h2>All Pages</h2>
            </div>
            <div class="col-md-6">
                <div class="text-right">
                    <a href="/admin/pages/create" class="btn btn-success">New Page</a>
                </div>
            </div>
        </div>

        <div class="row">
            @foreach(Page::protectedPages() AS $page)
                <div class="col-sm-12">
                    <div class="item">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="row">
                                    <div class="col-sm-12 h3">
                                        <div class="">{!! $page->title !!}</div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="pages-url">
                                            <a target="_blank" class="parent-link" href="{{ url($page->slug) }}">{{ url($page->slug) }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 text-right">
                                <div class="btn">{{ Page::statuses()[$page->active] }}</div>
                                <a data-container="body" data-toggle="popover" data-placement="top" data-content="Edit this page." href="{{ route('admin.pages.update', ['id' => $page->id]) }}" class="btn btn-primary edit-btn"><i class="fa fa-edit"></i></a>
                            </div>

                            @if($page->allow_children==1)
                                <div class="col-sm-12">
                                    <div class="row plot-order-drop" order-category="pages/{{ $page->id }}" id="pageOrder{{ $page->id }}" uk-sortable="">
                                        @foreach(Page::children($page->id) AS $child)
                                            <div class="col-sm-12 pl-5 child-item plot-order-item" order-id="{{ $child->id }}">
                                                <div class="row bg-child justify-content-center align-items-center">
                                                    <div class="col-sm-8 d-flex align-items-center h-100 my-3">
                                                        <div class="row">
                                                            <div class="col-sm-12">
                                                                <div class="h4">
                                                                    <i class="fa fa-arrows-alt"></i>&nbsp;{!! $child->title !!}
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-12">
                                                                <div class="pages-url w-100"> <a target="_blank" class="parent-link" href="{{ url($child->slug) }}">{{ url($child->slug) }}</a></div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4 text-right">
                                                        <div class="btn page-status-{{ strtolower(str_replace(' ','-',$child->active)) }}">
                                                            {{ Page::statuses()[$child->active] }}
                                                        </div>

                                                        <a href="{{ route('admin.pages.update', ['id' => $child->id]) }}" class="btn btn-primary"><i class="fa fa-edit"></i></a>
                                                        
                                                        <a href="#" data-href="/admin/pages/delete/{{ $child->id }}" data-toggle="modal" class="btn btn-danger" data-target="#confirm-delete"><i class="fa fa-trash"></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>


<!-- Delete modal for all the pages -->
<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="deleteProductParameter" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header"></div>
            <div class="modal-body">
                Are you sure you want delete this Page?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <a class="btn btn-danger btn-ok">Delete</a>
            </div>
        </div>
    </div>
</div>

@endsection
