@extends('admin.view')

@section('content')

    <div class="container-fluid">
        <h2 class="box-title">All Site Settings</h2>
        
        <div class="row">
            <div class="col-md-12">
                <div class="well">
                    <div class="row reverse">
                        <div class="col-md-3">
                            <h3><strong>Setting</strong></h3>
                        </div>
                        <div class="col-md-6">
                            <h3><strong>Value</strong></h3>
                        </div>
                        <div class="col-md-3">
                            <!-- Edit button -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @foreach(Setting::getAll() AS $setting)
            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-3 setting-title">
                                {!! $setting->setting !!}
                            </div>
                            <div class="col-md-6">
                                {!! $setting->value !!}
                            </div>
                            <div class="col-md-3 text-right">
                                <a href="/admin/settings/update/{{ $setting->id }}" class="btn btn-primary"><i class="fa fa-pen"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>

@endsection
