@extends('admin.view')

@section('content')

    <div class="container-fluid">

        <h2>Create News Article</h2>
        
        {!! Media::manager('news', 'News Media Manager') !!}
        <form action="/admin/news/create" method="post" enctype="multipart/form-data" create-form>
            @csrf
            <input class="hidden-status" type="hidden" name="active" value="{!! old('status') ? '1' : '0' !!}">

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Title</label>
                                    <input type="text" name="title" class="form-control" required value="{{ old('title') }}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Author</label>
                                    <input type="text" name="author" class="form-control" required value="{{ old('author') }}">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Snippet</label>
                                    <input type="text" name="snippet" class="form-control" value="{{ old('snippet') }}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Published</label>
                                    <input type="date" name="published" class="form-control" value="{{ old('published') }}">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Intro Content</label>
                                    <textarea name="intro_content" class="form-control tiny"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Secondary Content</label>
                                    <textarea name="secondary_content" class="form-control tiny"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>SEO Title</label>
                                    <input type="text" name="seo_title" class="form-control" value="{{ old('seo_title') ?: old('title') }}">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>SEO Description</label>
                                    <textarea name="seo_description" class="form-control">{{ old('seo_description') ?: '' }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

             <label>Activate</label>
            <button type="button" class="btn btn-lg btn-toggle {!! old('status') ? 'active' : 'inactive' !!} btn-status" data-toggle="button" aria-pressed="{!! old('status') ? 'active' : 'inactive' !!}" autocomplete="off">
                <div class="handle"></div>
            </button>
            <button type="submit" class="btn btn-success">Create News Article</button>
            <a href="{{ route('admin.news.index') }}" class="btn btn-default">Cancel</a>
        </form>
    </div>

@endsection
