<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;

use App\Http\Controllers\Controller;

use App\Account;
use App\Grids\AccountsGrid;

class AccountController extends Controller
{
    public $view = 'admin.crud.accounts.';
    public $route = '/admin/accounts';

    /**
     * Handles GET requests to /admin/accounts/index
     *
     * @return {view}
     */
    public function index(Request $request)
    {
        return (new AccountsGrid())
            ->create(['query' => Account::query(), 'request' => $request,  'account'])
            ->renderOn($this->view . 'index', [], 'account');
    }

    /**
     * Handles GET requests to /admin/accounts/update
     *
     * @return {view} Form for update account page
     */
    public function show(Request $request)
    {
        $account = Account::where('id', $request->id)->first();
        if (!$account) {
            return redirect($this->route)->with('danger', 'Sorry, that record could not be found');
        }

        return view($this->view . 'update')
            ->with('item', $account);
    }

    /**
     * Handles POST requests to /admin/accounts/update
     * Form submission from update account page
     *
     * @param  {Request} $request
     *
     * @return {array} Indicates success or failure
     */
    public function update(Request $request, int $id)
    {
        $account = Account::where('id', $id)->first();
        if (!$id) {
            return redirect($this->route)->with('danger', 'Sorry, that record could not be found');
        }

        // Unique email
        $email = Account::where('email', $request->email)->where('id', '!=', $id)->first();
        if ($email) {
            return redirect()->back()
                ->withInput($request->input())
                ->with('danger', 'An account with this email address already exists.');
        }

        try {
            $data = $request->except('_token');
            $account->update($data);
            return redirect($this->route)->with('success', 'Record successfully updated');
        } catch (Exception $e) {
            return redirect($this->route)->with('danger', 'Sorry, Account could not be updated.');
        }
    }
}
