<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Title
    |--------------------------------------------------------------------------
    |
    | Here you can change the default title of your admin panel.
    |
    | For more detailed instructions you can look here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/#61-title
    |
    */

    'title' => 'CCBackslash',
    'title_prefix' => '',
    'title_postfix' => '',

    /*
    |--------------------------------------------------------------------------
    | Logo
    |--------------------------------------------------------------------------
    |
    | Here you can change the logo of your admin panel.
    |
    | For more detailed instructions you can look here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/#62-logo
    |
    */

    'logo' => '<b>CC</b>Backslash',
    'logo_img' => 'https://clevercherry.com/images/logo-cc-white.png',
    'logo_img_class' => 'brand-image-xl',
    'logo_img_xl' => 'https://clevercherry.com/images/logo-white.png',
    'logo_img_xl_class' => 'brand-image-xs',
    'logo_img_alt' => 'CCBackslash',

    /*
    |--------------------------------------------------------------------------
    | Layout
    |--------------------------------------------------------------------------
    |
    | Here we change the layout of your admin panel.
    |
    | For more detailed instructions you can look here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/#63-layout
    |
    */

    'layout_topnav' => null, // this will always stay null as we do not want a top navigation
    'layout_boxed' => null,
    'layout_fixed_sidebar' => null,
    'layout_fixed_navbar' => null,
    'layout_fixed_footer' => null,

    /*
    |--------------------------------------------------------------------------
    | Extra Classes
    |--------------------------------------------------------------------------
    |
    | Here you can change the look and behavior of the admin panel.
    |
    | For more detailed instructions you can look here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/#64-classes
    |
    */

    // classes_body - change accent colors - see https://adminlte.io/themes/dev/AdminLTE/pages/tables/data.html four squares
    'classes_body' => '',
    // classes_brand - change brand logo background color
    'classes_brand' => '',
    'classes_brand_text' => '',

    'classes_content_header' => 'container-fluid',
    'classes_content' => '',
    // classes_sidebar - change main theme color dark or light - see https://adminlte.io/themes/dev/AdminLTE/pages/tables/data.html four squares
    'classes_sidebar' => 'sidebar-dark-warning elevation-4',
    'classes_sidebar_nav' => 'text-sm nav-compact nav-child-indent',
    'classes_topnav' => 'navbar-white navbar-light',
    'classes_topnav_nav' => 'navbar-expand-md',
    'classes_topnav_container' => 'container',

    /*
    |--------------------------------------------------------------------------
    | Sidebar
    |--------------------------------------------------------------------------
    |
    | Here we can modify the sidebar of the admin panel.
    |
    | For more detailed instructions you can look here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/#65-sidebar
    |
    */

    'sidebar_mini' => true,
    'sidebar_collapse' => false,
    'sidebar_collapse_auto_size' => false,
    'sidebar_collapse_remember' => false,
    'sidebar_collapse_remember_no_transition' => true,
    'sidebar_scrollbar_theme' => 'os-theme-light',
    'sidebar_scrollbar_auto_hide' => 'l',
    'sidebar_nav_accordion' => true,
    'sidebar_nav_animation_speed' => 300,

    /*
    |--------------------------------------------------------------------------
    | Control Sidebar (Right Sidebar)
    |--------------------------------------------------------------------------
    |
    | Here we can modify the right sidebar aka control sidebar of the admin panel.
    |
    | For more detailed instructions you can look here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/#66-control-sidebar-right-sidebar
    |
    */

    'right_sidebar' => false,
    'right_sidebar_icon' => 'fas fa-cogs',
    'right_sidebar_theme' => 'dark',
    'right_sidebar_slide' => true,
    'right_sidebar_push' => true,
    'right_sidebar_scrollbar_theme' => 'os-theme-light',
    'right_sidebar_scrollbar_auto_hide' => 'l',

    /*
    |--------------------------------------------------------------------------
    | URLs
    |--------------------------------------------------------------------------
    |
    | Here we can modify the url settings of the admin panel.
    | Set to false if you want to remove the links/ buttons
    |
    | For more detailed instructions you can look here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/#67-urls
    |
    */

    'use_route_url' => 'admin.logout',

    'dashboard_url' => 'admin.index',

    'logout_url' => 'admin.logout',

    'login_url' => 'admin.login',

    'register_url' => false,

    'password_reset_url' => false,

    'password_email_url' => false,

    /*
    |--------------------------------------------------------------------------
    | Laravel Mix
    |--------------------------------------------------------------------------
    |
    | Here we can enable the Laravel Mix option for the admin panel.
    |
    | For more detailed instructions you can look here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/#68-laravel-mix
    |
    */

    'enabled_laravel_mix' => false,

    /*
    |--------------------------------------------------------------------------
    | Menu Items
    |--------------------------------------------------------------------------
    |
    | Here we can modify the sidebar/top navigation of the admin panel.
    |
    | For more detailed instructions you can look here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/#69-menu
    |
    */

    'menu' => [
        [
            'text'        => 'Dashboard',
            'icon'        => 'fas fa-home',
            'url'         => '/admin/',
        ],
        ['header' => 'main_navigation'],
        [
            'text'        => 'Pages',
            'icon'        => 'fas fa-file',
            'url'         => '/admin/pages/',
        ],
        [
            'text'        => 'News',
            'icon'        => 'fas fa-typewriter',
            'url'         => '/admin/news/',
        ],
        ['header' => 'PRODUCTS'],
        [
            'text'        => 'Product Categories',
            'icon'        => 'fas fa-cabinet-filing',
            'url'         => '/admin/product-categories/',
        ],
        [
            'text'        => 'Products',
            'icon'        => 'fad fa-boxes',
            'url'         => '/admin/products',
        ],
        ['header' => 'CUSTOMERS'],
        [
            'text'        => 'Accounts',
            'icon'        => 'fas fa-user-circle',
            'url'         => '/admin/accounts/',
        ],
        
        [
            'text'        => 'Newsletter Signups',
            'icon'        => 'fas fa-newspaper',
            'url'         => '/admin/newsletter/'
        ],
        [
            'text'        => 'Enquiries',
            'icon'        => 'fa fa-comments',
            'url'         => '/admin/enquiry'
        ],
        ['header' => 'settings'],
        [
            'text' => 'Site Settings',
            'url'  => '/admin/settings',
            'icon' => 'fas fa-cogs',
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | Menu Filters
    |--------------------------------------------------------------------------
    |
    | Here we can modify the menu filters of the admin panel.
    |
    | For more detailed instructions you can look here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/#610-menu-filters
    |
    */

    'filters' => [
        Clevercherry\Adminlte\Menu\Filters\HrefFilter::class,
        Clevercherry\Adminlte\Menu\Filters\SearchFilter::class,
        Clevercherry\Adminlte\Menu\Filters\ActiveFilter::class,
        Clevercherry\Adminlte\Menu\Filters\SubmenuFilter::class,
        Clevercherry\Adminlte\Menu\Filters\ClassesFilter::class,
        Clevercherry\Adminlte\Menu\Filters\GateFilter::class,
        Clevercherry\Adminlte\Menu\Filters\LangFilter::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Plugins Initialization
    |--------------------------------------------------------------------------
    |
    | Here we can modify the plugins used inside the admin panel.
    |
    | For more detailed instructions you can look here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/#611-plugins
    |
    */

    'plugins' => [
        [
            'name' => 'Datatables',
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => false,
                    'location' => '//cdn.datatables.net/v/bs/dt-1.10.18/datatables.min.js',
                ],
                [
                    'type' => 'css',
                    'asset' => false,
                    'location' => '//cdn.datatables.net/v/bs/dt-1.10.18/datatables.min.css',
                ],
            ],
        ],
        [
            'name' => 'Select2',
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => false,
                    'location' => '//cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/js/select2.min.js',
                ],
                [
                    'type' => 'css',
                    'asset' => false,
                    'location' => '//cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/css/select2.css',
                ],
            ],
        ],
        [
            'name' => 'Chartjs',
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => false,
                    'location' => '//cdnjs.cloudflare.com/ajax/libs/Chart.js/2.7.0/Chart.bundle.min.js',
                ],
            ],
        ],
        [
            'name' => 'Sweetalert2',
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => false,
                    'location' => '//cdn.jsdelivr.net/npm/sweetalert2@8',
                ],
            ],
        ],
        [
            'name' => 'Pace',
            'active' => false,
            'files' => [
                [
                    'type' => 'css',
                    'asset' => false,
                    'location' => '//cdnjs.cloudflare.com/ajax/libs/pace/1.0.2/themes/blue/pace-theme-center-radar.min.css',
                ],
                [
                    'type' => 'js',
                    'asset' => false,
                    'location' => '//cdnjs.cloudflare.com/ajax/libs/pace/1.0.2/pace.min.js',
                ],
            ],
        ],
    ],
];
