<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

use App\Http\Controllers\Controller;

use App\Newsletter;
use App\Grids\NewsletterGrid;

class NewsletterController extends Controller
{
    public $view = 'admin.crud.newsletter.';
    public $route = '/admin/newsletter';

    /**
     * Handles GET requests to /admin/newsletters/index
     *
     * @return {view}
     */
    public function index(Request $request)
    {
        return (new NewsletterGrid())
            ->create(['query' => Newsletter::query(), 'request' => $request,  'newsletter'])
            ->renderOn($this->view . 'index', [], 'newsletter');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @return \Illuminate\Http\Response
     */
    public function delete(Request $request, int $id)
    {
        $model = Newsletter::find($id);
        if (!$model) {
            return redirect($this->route)->with('danger', 'Sorry, the record could not be found');
        }

        $model->delete();
        return redirect($this->route)->with('success', 'Successfully deleted newsletter signup!');
    }
}
