<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;

use App\Http\Controllers\Controller;

use App\Models\Enquiry;
use App\Grids\EnquiriesGrid;

class EnquiryController extends Controller
{
    public $view = 'admin.crud.enquiries.';
    public $route = '/admin/enquiry';

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
        return (new EnquiriesGrid())
            ->create(['query' => Enquiry::query()->orderBy('created_at', 'DESC'), 'request' => $request,  'enquiry'])
            ->renderOn($this->view . 'index', [], 'enquiry');
    }

    /**
     * Handles GET requests to /admin/enquiries/update
     *
     * @return {view} Form for update enquiry page
     */
    public function show(Request $request)
    {
        $enquiry = Enquiry::where('id', $request->id)->first();
        if (!$enquiry) {
            return redirect($this->route)->with('danger', 'Sorry, that record could not be found');
        }

        return view($this->view . 'update')
            ->with('item', $enquiry);
    }

    /**
     * Handles POST requests to /admin/enquiries/update
     * Form submission from update enquiry page
     *
     * @param  {Request} $request
     *
     * @return {array} Indicates success or failure
     */
    public function update(Request $request, int $id)
    {
        $enquiry = Enquiry::where('id', $id)->first();
        if (!$id) {
            return redirect($this->route)->with('danger', 'Sorry, that record could not be found');
        }

        try {
            $data = [
                'notes' => $request->notes,
                'read' => $request->read
            ];
            $enquiry->update($data);
            return redirect($this->route)->with('success', 'Record successfully updated');
        } catch (Exception $e) {
            return redirect($this->route)->with('danger', 'Sorry, Enquiry could not be updated.');
        }
    }

    /**
     * Remove the specified enquiry
     *
     * @param  {Request}  $request
     * @param  {int}  $id - enquiry id
     * 
     * @return {array} Indicates success or failure
     */
    public function delete(Request $request, int $id)
    {
        $model = Enquiry::find($id);
        if (!$model) {
            return redirect($this->route)->with('danger', 'Sorry, the record could not be found');
        }

        $model->delete();
        return redirect($this->route)->with('success', 'Successfully deleted the enquiry!');
    }
}
