@extends('adminlte::page')

@section('title', config('adminlte.title'))

@section('css')
	<link rel="stylesheet" href="https://use.typekit.net/gtr8tdb.css">

	<!-- UIkit CSS -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/uikit@3.2.6/dist/css/uikit.min.css" />

	<!-- UIkit JS -->
	<script src="https://cdn.jsdelivr.net/npm/uikit@3.2.6/dist/js/uikit.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/uikit@3.2.6/dist/js/uikit-icons.min.js"></script>

	<link rel="apple-touch-icon" sizes="180x180" href="/images/icons/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="https://clevercherry.com/images/icon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="https://clevercherry.com/images/icon/favicon-16x16.png">

	<!-- Gridview CSS -->
	<link rel="stylesheet" type="text/css" href="{{ asset('clevercherry/grid/css/grid.css') }}" />
@endsection

@section('content_header')
 	@include('admin.partials.alerts')
 	@include('clevercherry::modal.container')
@endsection

@section('footer')
	<div class="float-right d-none d-sm-block">
    	<b>Version</b> 1.0.0
    </div>
    <strong>Copyright © 2020 <a href="https://clevercherry.com/">Clevercherry</a>.</strong>
    All rights reserved.
@endsection

@section('js')
	<!-- moment js (required by datepicker library) -->
	<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.22.1/moment.min.js"></script>
	<!-- pjax js (required) -->
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.pjax/2.0.1/jquery.pjax.min.js"></script>
	<!-- required to supply js functionality for the grid -->
	<script src="{{ asset('clevercherry/grid/js/grid.js') }}"></script>
	<!-- entry point for all scripts injected by the generated grids (required) -->
	@stack('grid_js')

	<script src="https://cloud.tinymce.com/stable/tinymce.min.js?apiKey=1rrp584vjzmlt4o7r89n0vsrkvhdku8lszy6wxzecuuo9vjh"></script>
	<script>

	tiny();
	function tiny()
	{
	    tinymce.init({
	        selector: 'textarea.tiny',
	        plugin: 'a_tinymce_plugin',
	        a_plugin_option: true,
	        a_configuration_option: 400,
	        height: 170,
	        menubar: false,
	        plugins: [
	          'advlist autolink lists link charmap print preview anchor textcolor',
	          'searchreplace visualblocks fullscreen',
	          'insertdatetime table contextmenu paste help '
	        ],
	        toolbar: 'bold italic link',
	        setup : function(editor) {
	            editor.on("change keyup", function(e){
	                editor.save(); // updates this instance's textarea
	                $(editor.getElement()).trigger('change'); // for garlic to detect change
	            });
	        }
	    });
	    
	    tinymce.init({
	        selector: 'textarea.tiny-bullet',
	        plugin: 'a_tinymce_plugin',
	        a_plugin_option: true,
	        a_configuration_option: 400,
	        height: 170,
	        menubar: false,
	        plugins: [
	          'advlist autolink lists link charmap print preview anchor textcolor',
	          'searchreplace visualblocks fullscreen',
	          'insertdatetime table contextmenu paste help '
	        ],
	        toolbar: 'bold italic link bullist',
	        setup : function(editor) {
	            editor.on("change keyup", function(e){
	                editor.save(); // updates this instance's textarea
	                $(editor.getElement()).trigger('change'); // for garlic to detect change
	            });
	        }
	    });
	}

	</script>
@endsection
