@extends('admin.view')

@section('content')

	<div class="container-fluid">
        <div class="row">
            <div class="col-md-6">
                <h2>Create Product</h2>
            </div>
        </div>

        {!! Media::manager('products', 'Products', 'Products Media Manager') !!}

	    <form action="/admin/products/create" method="post" enctype="multipart/form-data" create-form>
		    
            @csrf

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
            		    <div class="row">
            		        <div class="col-md-12">
            		            <div class="form-group">
            		                <label>Product Category</label>
            					    <select name="product_category" class="form-control" required>
            				            <option value="" disabled selected>Select Product Category</option>
            				            @foreach(ProductCategory::getAll() AS $value)
            				                <option value="{{ $value->id }}"
            				                	@if(old('product_category')==$value->id )
            		                        		selected
            		                    		@endif
            		                    	>
            				                    {!! $value->title !!}
            				                </option>
            				            @endforeach
            				        </select>
            		            </div>
            		        </div>
            		    </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Status</label>
                                    <select name="status" class="form-control" required>
                                        <option value="" disabled selected>Select Status</option>
                                        @foreach(Product::statuses() AS $key => $value)
                                            <option value="{{ $key }}"
                                                @if(old('status')==$key )
                                                    selected
                                                @endif
                                            >
                                                {!! $value !!}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Name</label>
                                    <input type="text" name="name" class="form-control" placeholder="Enter product name" value="{{ old('name') }}" required>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
            		    <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Code</label>
                                    <input type="text" name="code" class="form-control" placeholder="Enter product code" value="{{ old('code') }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Price</label>
                                    <input type="number" class="form-control" name="price" placeholder="Enter base price" value="{{ old('price') }}" required>
                                </div>
                            </div>
            		    </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Content</label>
                                    <textarea name="content" class="form-control tiny">{{ old('content') }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
            		    <div class="row">
            		   		<div class="col-md-12">
            		            <div class="form-group">
            		            	<label>Seo Title</label>
            		            	<input type="text" name="seo_title" class="form-control" value="{{ old('seo_title') ?: old('name') }}">
            		            </div>
            		        </div>
            		        <div class="col-md-12">
            		            <div class="form-group">
            		                <label>Seo Description</label>
            		                <textarea name="seo_description" class="form-control">{{ old('seo_description') ?: '' }}</textarea>
            		            </div>
            		        </div>
            		    </div>
                    </div>
                </div>
            </div>

		    <button type="submit" class="btn btn-primary">Create</button>
		    <a href="/admin/products/" class="btn btn-default">Cancel</a>
	    </form>
	</div>

@endsection
