<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Newsletter extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'newsletters';
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'full_name', 'email'
    ];
  
    /**
     * Returns a list of all signups
     * 
     * @return array
     */
    public static function getAll()
    {
        return self::orderBy('created_at', 'desc')->get();
    }
}
