@extends('admin.view')

@section('content')

	<div class="container-fluid">

	    <div class="row">
	        <div class="col-md-6">
	            <h2>Update Product Category {!! $item->title !!}</h2>
	        </div>
	        <div class="col-md-6">
	            <div class="text-right">
                	<div class="form-group nm">
                		<label>Activate</label>
            			<button type="button" class="btn btn-lg btn-toggle {!! $item->active ? 'active' : '' !!} btn-status" data-toggle="button" aria-pressed="{!! $item->active ? 'active' : 'inactive' !!}" autocomplete="off">
            			    <div class="handle"></div>
            			</button>
                	</div>
	            </div>
	        </div>
	    </div>

        {!! Media::manager('product_categories', 'Product Categories', 'Product Categories Media Manager', $item->id) !!}

	    <form action="/admin/product-categories/update/{!! $item->id !!}" method="post" enctype="multipart/form-data">
		    @csrf
		    <input type="hidden" name="id" value="{{ $item->id }}">
			<input class="hidden-status" type="hidden" name="active" value="{!! $item->active ? '1' : '0' !!}">

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
            		    <div class="row">
            		        <div class="col-md-12">
            		            <div class="form-group">
            		                <label>Title</label>
            		                <input type="text" name="title" class="form-control" value="{{ $item->title }}" required>
            		            </div>
            		        </div>
            		    </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
            		    <div class="row">
            		        <div class="col-md-12">
            		            <div class="form-group">
            		                <label>Description</label>
            		                <input type="text" name="description" maxlength="250" class="form-control" value="{{ $item->description }}">
            		            </div>
            		        </div>
            		    </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
            		    <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Content</label>
                                    <textarea name="content" class="form-control tiny">{{ $item->content }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
            		    <div class="row">
            		   		<div class="col-md-12">
            		            <div class="form-group">
            		            	<label>Seo Title</label>
            		            	<input type="text" name="seo_title" class="form-control" value="{{ $item->seo_title ?: $item->title }}">
            		            </div>
            		        </div>
            		        <div class="col-md-12">
            		            <div class="form-group">
            		                <label>Seo Description</label>
            		                <textarea name="seo_description" class="form-control">{{ $item->seo_description ?: '' }}</textarea>
            		            </div>
            		        </div>
            		    </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <button type="submit" class="btn btn-success">Update</button>
                    <a href="{{ route('admin.product-categories.index') }}" class="btn btn-default">Cancel</a>
                </div>
            </div>

	    </form>
	</div>

@endsection
