<?php
 
namespace App\Http\Controllers\Admin;
 
use Illuminate\Http\Request;

use App\Http\Controllers\Controller;
use App\Setting AS Model;
 
class SettingController extends Controller
{
    /**
     * @var directory path for the crud views
     */
    public $view = 'admin.crud.settings.';
  
    /**
     * @var admin paths and URLs
     */
    public $adminUrl = '/admin/settings';
 
   
    /**
     * Returns the admin settings index view in the CMS
     * @return type
     */
    public function index()
    {
        return view($this->view.'index');
    }
   
    /**
     * Stores or updates a record
     * @param Request $request
     * @return type
     */
    public function store(Request $request)
    {
        try{
            $store = $request->except('_token');
            $item = Model::updateOrCreate(['id' => $request->id], $store);
            return redirect($this->adminUrl)->with('success', 'Record successfully updated');
   
        } catch(\Exception $e){
            return redirect()->back()->with('danger', 'An unknown error has occured, please try again and contact your account manager if this error persists');
        }
    }
  
    /**
     * Loads the update form for an existing record
     * @param type $id
     * @return type
     */
    public function update(int $id)
    {
        $item = Model::where('id', $id)->first();
   
        if(! $item){
            return redirect($this->adminUrl)->with('danger', 'Sorry, that record could not be found');
        }
   
        return view($this->view.'update')
            ->with('item', $item);
    }
}