<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ProductCategory extends Model
{
    const ACTIVE = 1;
    const INACTIVE = 0;

    const UNCATEGORISED_ID = 1;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'product_categories';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'title', 'description', 'content', 'seo_title', 'seo_description', 'active', 'order', 'slug'
    ];
  
    /**
     * Returns a list of all product categories ordered by the order set up in the cms
     * @return array
     */
    public static function getAll()
    {
        $cat = self::where('id', '!=', self::UNCATEGORISED_ID)
        ->orderBy('order', 'ASC')->get();
        return $cat ?: [];
    }

    /**
     * Returns a list of all product categories ordered by the order set up in the cms
     * @return array
     */
    public static function getAllWithUncategorised()
    {
        $cat = self::orderBy('order', 'ASC')->get();
        return $cat ?: [];
    }

    /**
     * Returns the name of the product category from the id
     * @return array
     */
    public static function getName(int $id)
    {
        $cat = self::where('id', $id)->first();
        return $cat['title'];
    }

    /**
     * Returns a product cat slug
     * @param int $id
     * @return type
     */
    public static function slug(string $slug)
    {
        return self::where('slug', $slug)->first();
    }
}
