<?php
 
namespace App;

use Illuminate\Database\Eloquent\Model;

class News extends Model
{
    const ACTIVE = 1;
    const INACTIVE = 0;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'news';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'id', 'title', 'author', 'slug', 'snippet', 'intro_content','secondary_content', 'seo_title', 'seo_description', 'active', 'published'
    ];

    /**
     * Returns an array of all news statuses
     * @return array
     */
    public static function statuses()
    {
        return array(
            self::ACTIVE => "Active",
            self::INACTIVE => "Inactive"
        );
    }

    /**
     * Returns an array of all news
     * @return array
     */
    public static function getAll()
    {
        return self::orderBy('published', 'desc')->get();
    }

    /**
     * Returns a new object based on id
     * @param int $id
     * @return row|empty
     */
    public static function id(int $id)
    {
        return self::where('id', $id)->first();
    }

    /**
     * Returns a news object based on slug
     * @param string $slug
     * @return row|empty
     */
    public static function slug(string $slug)
    {
        return self::where('slug', $slug)->first();
    }
}
