<?php
 
namespace App\Console\Commands;
 
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Hash;
use App\Admin AS AdminUser;
 
class admin extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'admin:new';
 
    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Creates a new admin user';
 
    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }
 
    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $store = [];
        $store['name'] = $this->ask('Full Name');
        $store['email'] = $this->ask('Email');
        $store['password'] = $this->secret('Password');
        $password_confirmation = $this->secret('Confirm Password');
 
        $check = AdminUser::where('email', $store['email']);
 
        if(! empty($check->email)) {
            return $this->error('Email address already in use');
        }
 
        if($store['password']!==$password_confirmation){
            $password = $this->passwordRetry();
        }
 
        $store['password'] = Hash::make($store['password']);
 
        if( AdminUser::create($store)){
            return $this->info('New admin user successfully created');
        }
        return $this->error('Sorry an unknown error occured');
    }
 
    /**
     * Retry new password
     * @return type
     */
    public function passwordRetry()
    {
        $this->error('Passwords don\'t match, please try again');
        $password = $this->secret('Password');
        $password_confirmation = $this->secret('Confirm Password');
 
        if($password!==$password_confirmation){
            $password = $this->passwordRetry();
        }
 
        return $password;
    }
}
