<?php

namespace Clevercherry\AdminLte\Menu\Filters;

use Clevercherry\AdminLte\Menu\ActiveChecker;
use Clevercherry\AdminLte\Menu\Builder;

class ActiveFilter implements FilterInterface
{
    private $activeChecker;

    public function __construct(ActiveChecker $activeChecker)
    {
        $this->activeChecker = $activeChecker;
    }

    public function transform($item, Builder $builder)
    {
        if (! isset($item['header'])) {
            $item['active'] = $this->activeChecker->isActive($item);
        }

        return $item;
    }
}
