@extends('backslash::master')

@section('backslash_css')
    @yield('css')
@stop

@section('classes_body', 'login-page')

@php( $password_email_url = View::getSection('password_email_url') ?? config('backslash.password_email_url', 'password/email') )
@php( $dashboard_url = View::getSection('dashboard_url') ?? config('backslash.dashboard_url', 'home') )

@if (config('backslash.use_route_url', false))
    @php( $password_email_url = $password_email_url ?? route($password_email_url) )
    @php( $dashboard_url = $dashboard_url ?? route($dashboard_url) )
@else
    @php( $password_email_url = $password_email_url ?? url($password_email_url) )
    @php( $dashboard_url = $dashboard_url ?? url($dashboard_url) )
@endif

@section('body')
    <div class="login-box">
        <div class="login-logo">
            <a href="{{ $dashboard_url }}">{!! config('backslash.logo', '<b>Admin</b>LTE') !!}</a>
        </div>
        <div class="card">
            <div class="card-body login-card-body">
                <p class="login-box-msg">{{ __('backslash::backslash.password_reset_message') }}</p>
                @if (session('status'))
                    <div class="alert alert-success">
                        {{ session('status') }}
                    </div>
                @endif
                <form action="{{ $password_email_url }}" method="post">
                    {{ csrf_field() }}
                    <div class="input-group mb-3">
                        <input type="email" name="email" class="form-control {{ $errors->has('email') ? 'is-invalid' : '' }}" value="{{ old('email') }}" placeholder="{{ __('backslash::backslash.email') }}">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-envelope"></span>
                            </div>
                        </div>
                        @if ($errors->has('email'))
                            <div class="invalid-feedback">
                                {{ $errors->first('email') }}
                            </div>
                        @endif
                    </div>
                    <button type="submit" class="btn btn-primary btn-block btn-flat">
                        {{ __('backslash::backslash.send_password_reset_link') }}
                    </button>
                </form>
            </div>
        </div>
    </div>
@stop

@section('backslash_js')
    <script src="{{ asset('vendor/backslash/dist/js/adminlte.min.js') }}"></script>
    @stack('js')
    @yield('js')
@stop
