<?php

namespace Clevercherry\Adminlte;

use Illuminate\Contracts\Config\Repository;
use Illuminate\Contracts\Container\Container;
use Illuminate\Contracts\Events\Dispatcher;
use Illuminate\Contracts\View\Factory;
use Illuminate\Support\ServiceProvider as BaseServiceProvider;
use Clevercherry\Adminlte\Console\AdminlteInstallCommand;
use Clevercherry\Adminlte\Console\AdminltePluginCommand;
use Clevercherry\Adminlte\Console\AdminlteStatusCommand;
use Clevercherry\Adminlte\Console\AdminlteUpdateCommand;
use Clevercherry\Adminlte\Events\BuildingMenu;
use Clevercherry\Adminlte\Http\ViewComposers\AdminlteComposer;

class AdminlteServiceProvider extends BaseServiceProvider
{
    public function register()
    {
        $this->app->singleton(Adminlte::class, function (Container $app) {
            return new Adminlte(
                $app['config']['adminlte.filters'],
                $app['events'],
                $app
            );
        });
    }

    public function boot(
        Factory $view,
        Dispatcher $events,
        Repository $config
    ) {
        $this->loadViews();

        $this->loadTranslations();

        $this->loadConfig();

        $this->registerCommands();

        $this->registerViewComposers($view);

        static::registerMenu($events, $config);
    }

    private function loadViews()
    {
        $viewsPath = $this->packagePath('resources/views');
        $this->loadViewsFrom($viewsPath, 'adminlte');
    }

    private function loadTranslations()
    {
        $translationsPath = $this->packagePath('resources/lang');

        $this->loadTranslationsFrom($translationsPath, 'adminlte');
    }

    private function loadConfig()
    {
        $configPath = $this->packagePath('config/adminlte.php');

        $this->mergeConfigFrom($configPath, 'adminlte');
    }

    private function packagePath($path)
    {
        return __DIR__."/../$path";
    }

    private function registerCommands()
    {
        $this->commands(AdminlteInstallCommand::class);
        $this->commands(AdminlteStatusCommand::class);
        $this->commands(AdminlteUpdateCommand::class);
        $this->commands(AdminltePluginCommand::class);
    }

    private function registerViewComposers(Factory $view)
    {
        $view->composer('adminlte::page', AdminlteComposer::class);
    }

    public static function registerMenu(Dispatcher $events, Repository $config)
    {
        $events->listen(BuildingMenu::class, function (BuildingMenu $event) use ($config) {
            $menu = $config->get('adminlte.menu');
            call_user_func_array([$event->menu, 'add'], $menu);
        });
    }
}
